/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-08-04
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TIMEREFERENCE
#define TIMEREFERENCE

#include <QGpGuiTools.h>
#include "ui_TimeReference.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class GEOPSYGUI_EXPORT TimeReference : public Dialog, private Ui::TimeReference
{
  Q_OBJECT
public:
  TimeReference(QWidget * parent=nullptr);

  void setTrueTimeDate(double t0, QDateTime ref);
  double t0() const;
  QDateTime reference() const;
private slots:
  void on_refDateTime_dateTimeChanged(QDateTime);
private:
  double _t0;
};

} // namespace GeopsyGui

#endif // TIMEREFERENCE_H
