/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-08-29
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALGROUPITEM_H
#define SIGNALGROUPITEM_H

#include <GeopsyCore.h>
#include <QtGui>

#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class GEOPSYGUI_EXPORT SignalGroupItem: public QAbstractItemModel
{
  Q_OBJECT
public:
  SignalGroupItem(QObject * parent=nullptr);
  ~SignalGroupItem() {}

  void setDatabase(SignalDatabase * db);

  virtual int rowCount(const QModelIndex& parent=QModelIndex()) const;
  virtual int columnCount(const QModelIndex& parent=QModelIndex()) const;
  virtual QVariant data(const QModelIndex& index, int role) const;
  virtual bool setData(const QModelIndex& index, const QVariant& value, int role=Qt::EditRole);
  virtual QModelIndex parent(const QModelIndex& index) const;
  virtual QModelIndex index(int row, int column, const QModelIndex& parent=QModelIndex()) const;
  virtual Qt::ItemFlags flags(const QModelIndex&) const;
  virtual QStringList mimeTypes() const;
  virtual Qt::DropActions supportedDropActions() const;
  virtual QMimeData * mimeData(const QModelIndexList& indexes) const;
  virtual bool dropMimeData(const QMimeData * data, Qt::DropAction action,
                            int row, int column, const QModelIndex& parent);

  void addSignals(const SubSignalPool& sel, const QItemSelectionModel& sm);
  void getSelection(SubSignalPool& sel, const QItemSelectionModel& sm, const QModelIndex& parent=QModelIndex());
  void getSelection(QList<AbstractSignalGroup *>& sel, const QItemSelectionModel& sm, const QModelIndex& parent=QModelIndex());
  static AbstractSignalGroup * group(const QModelIndex& index);
  QModelIndex index(AbstractSignalGroup * g) const;
private slots:
  void databaseDestroyed();
  void dataChanged(AbstractSignalGroup * g);
  void parentAboutToBeChanged(AbstractSignalGroup * g, AbstractSignalGroup * newParent);
  void parentChanged(AbstractSignalGroup * g, AbstractSignalGroup * oldParent);
protected:
  SignalDatabase * _db;
};


} // namespace GeopsyGui

#endif // SIGNALGROUPITEM_H
