/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-02-02
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALFILEITEM_H
#define SIGNALFILEITEM_H

#include <GeopsyCore.h>

#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class GEOPSYGUI_EXPORT SignalFileItem : public QAbstractItemModel
{
public:
  SignalFileItem(SignalDatabase * db, QObject * parent=nullptr);
  ~SignalFileItem() {}

  void beginReset();
  void endReset();

  void beginAddFile();
  void endAddFile();

  virtual int rowCount(const QModelIndex &parent=QModelIndex()) const;
  virtual int columnCount(const QModelIndex &parent=QModelIndex()) const;
  virtual QVariant data(const QModelIndex &index, int role) const;
  virtual QModelIndex parent (const QModelIndex & index) const;
  virtual QModelIndex index (int row, int column, const QModelIndex & parent=QModelIndex()) const;
  virtual Qt::ItemFlags flags (const QModelIndex & ) const {return Qt::ItemIsSelectable | Qt::ItemIsEnabled;}

  void getSelection(SubSignalPool& sel, const QItemSelectionModel& sm);
  void getSelection(QList<SignalFile *>& sel, const QItemSelectionModel& sm);
  static SignalFile * file(const QModelIndex & index);
  QModelIndex index(SignalFile * f);
  void remove(const QList<SignalFile *>& sel);
private:
  SignalDatabase * _db;
};


} // namespace GeopsyGui

#endif // SIGNALFILEITEM_H
