/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-28
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef TIMEWINDOWLIST_H
#define TIMEWINDOWLIST_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"
#include "TimeRangeList.h"
#include "TimeWindow.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT TimeWindowList: public TimeRangeList, public XMLClass
  {
  public:
    TimeWindowList()
      : TimeRangeList(), XMLClass(), _defaultColor(200, 255, 193) {}
    TimeWindowList(const TimeWindowList& o, int firstIndex=0);
    ~TimeWindowList();

    virtual const QString& xml_tagName() const {return xmlTimeWindowListTag;}
    static const QString xmlTimeWindowListTag;

    void setDefaultColor(Color c) {_defaultColor=c;}
    Color defaultColor() const {return _defaultColor;}
    void resetColors();

    TimeWindow& addOne(const TimeRange& r) {return static_cast<TimeWindow&>(TimeRangeList::addOne(r));}
    TimeWindow& addOne() {return static_cast<TimeWindow&>(TimeRangeList::addOne());}

    const TimeWindow& at(int index) const {return static_cast<const TimeWindow&>(TimeRangeList::at(index));}
    TimeWindow& at(int index) {return static_cast<TimeWindow&>(TimeRangeList::at(index));}
  protected:
    virtual TimeRange * newTimeRange(const DateTime& start, const DateTime& end) {return new TimeWindow(start, end, _defaultColor);}
    virtual TimeRange * newTimeRange(const DateTime& start, double length) {return new TimeWindow(start, length, _defaultColor);}
    virtual TimeRange * cloneTimeRange(TimeRange * r) {return new TimeWindow(*static_cast<TimeWindow *>(r));}
    virtual void deleteTimeRange(TimeRange * r) {delete static_cast<TimeWindow *>(r);}

    virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
    virtual XMLMember xml_member(XML_MEMBER_ARGS);
    virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
  private:
    Color _defaultColor;
  };

} // namespace GeopsyCore

#endif // TIMEWINDOWLIST_H
