/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-08-26
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "SyscomHeader.h"

namespace GeopsyCore {

/*!
  \class SyscomHeader SyscomHeader.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

int SyscomHeader::bcd2int(uchar bcd)
{
  TRACE;
  return ((bcd & 0xF0) >> 3) * 5 + (bcd & 0x0F);
}

DateTime SyscomHeader::startTime(const Time& t)
{
  TRACE;
  int currentCentury=QDateTime::currentDateTime().date().year()/100*100;
  DateTime dt(QDate(currentCentury+bcd2int(t.YEAR), bcd2int(t.MONTH), bcd2int(t.DAY)), 0, 0.0);
  dt.addHours(bcd2int(t.HOUR));
  dt.addMinutes(bcd2int(t.MINUTE));
  dt.addSeconds(bcd2int(t.SECOND));
  return dt;
}

double SyscomHeader::countPerVolt(const Lsb& l)
{
  TRACE;
  return l.MANTISSA*pow(10.0,l.EXPONENT);
}

Signal::Components SyscomHeader::component(int channel)
{
  switch(channel) {
  case 0: return Signal::East;
  case 1: return Signal::North;
  default: return Signal::Vertical;
  }
}

} // namespace GeopsyCore
