/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-05-17
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALRESULTSFACTORY_H
#define SIGNALRESULTSFACTORY_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"
#include "AbstractSignalResults.h"

namespace GeopsyCore {

  #define REGISTER_SIGNALRESULTS(_className_, _tagName_) \
    XMLREGISTER_HEAD(SignalResultsFactory, XMLClassCreator, _className_, _tagName_) \
    XMLREGISTER_TAIL(_className_)

  #define SYNONYM_SIGNALRESULTS(_synName_, _tagName_) \
    XMLSYNONYM(SignalResultsFactory, _synName_, _tagName_)

  class GEOPSYCORE_EXPORT SignalResultsFactory : public XMLClassFactory
  {
  public:
    inline AbstractSignalResults * create(int id) const;
    inline AbstractSignalResults * create(const QString& tag) const;

    static void init();
    static SignalResultsFactory * instance() {init(); return _self;}
  private:
    static SignalResultsFactory * _self;
  };

  inline AbstractSignalResults * SignalResultsFactory::create(int id) const
  {
    return static_cast<AbstractSignalResults *>(XMLClassFactory::create(id));
  }

  inline AbstractSignalResults * SignalResultsFactory::create(const QString& tag) const
  {
    return static_cast<AbstractSignalResults *>(XMLClassFactory::create(tag));
  }

} // namespace GeopsyCore

#endif // SIGNALRESULTSFACTORY_H
