/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-10
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALEXPRESSION_H
#define SIGNALEXPRESSION_H

#include <QGpCoreTools.h>

#include "GeoSignal.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class SignalExpressionContext;

class GEOPSYCORE_EXPORT SignalExpression : public ExpressionStorage
{
public:
  SignalExpression(MetaDataIndex index, SignalExpressionContext * context) {_index=index; _context=context;}

  virtual bool isReadOnly() const;
  virtual QVariant value(const QString& index) const;
  virtual void setValue(const QString& index, const QVariant& val);
private:
  MetaDataIndex _index;
  SignalExpressionContext * _context;
};

} // namespace GeopsyCore

#endif // SIGNALEXPRESSION_H
