/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-10-19
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MINISEEDRECORDS_H
#define MINISEEDRECORDS_H

#include "MetaData.h"
#include "MiniSeedSequence.h"

namespace GeopsyCore {

  class MiniSeedRecords : public MetaData
  {
    METADATA_CLASS(MiniSeedRecords)
  public:
    MiniSeedRecords() {}

    virtual bool operator==(const MetaData& o) const {
      return _records==reinterpret_cast<const MiniSeedRecords&>(o)._records;
    }
    virtual int compare(int, const QString&, const MetaData&) const {return 0;}
    virtual void operator=(const MetaData&) {}

    virtual bool copyAllowed() const {return false;}
    virtual bool storeAsProperty() const {return false;}
    virtual bool fromString(const QString& , QString string); // Kept for compatibility

    void add(off_t pos, quint32 byteLength);

    int sequenceCount() const {return _records.count();}
    int recordCount(int sequenceIndex) const {return _records.at(sequenceIndex).count();}
    bool record(int sequenceIndex, int recordIndex, off_t& pos, quint32& byteLength) const;
  protected:
    virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
    virtual XMLMember xml_member(XML_MEMBER_ARGS);
    virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
  private:
    QVector<MiniSeedSequence> _records;
  };

} // namespace GeopsyCore

#endif // MINISEEDRECORDS_H
