/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-07-28
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "MetaDataIndex.h"
#include "MetaData.h"

namespace GeopsyCore {

  /*!
    \class MetaDataIndex MetaDataIndex.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Compares two indexes.
  */
  bool MetaDataIndex::operator<(const MetaDataIndex& o) const
  {
    if(_id<o._id) {
      return true;
    } else if(_id>o._id) {
      return false;
    } else {
      if(_subId<o._subId) {
        return true;
      } else if(_subId>o._subId) {
        return false;
      } else {
        return _index<o._index;
      }
    }
  }

} // namespace GeopsyCore
