/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-05-18
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef MASTERSIGNALGROUP_H
#define MASTERSIGNALGROUP_H

#include <QGpCoreTools.h>

#include "AbstractSignalGroup.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT MasterSignalGroup : public QObject, public AbstractSignalGroup,
      public UniqueID
  {
    Q_OBJECT
  public:
    MasterSignalGroup(SignalDatabase * database);

    virtual const QString& xml_tagName() const {return xmlMasterSignalGroupTag;}
    static const QString xmlMasterSignalGroupTag;
    virtual bool xml_inherits(const QString& tagName) const;

    void clear();
    virtual bool readOnly() const {return true;}
  protected:
    void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
    XMLMember xml_member(XML_MEMBER_ARGS);

    virtual void reportParentAboutToBeChanged(AbstractSignalGroup * g, AbstractSignalGroup * newParent) const;
    virtual void reportParentChanged(AbstractSignalGroup * g, AbstractSignalGroup * oldParent) const;
    virtual void reportDataChanged(AbstractSignalGroup * g) const;

    virtual int countId(int id, int& newId) const;
  signals:
    void dataChanged(AbstractSignalGroup * g) const;
    void parentAboutToBeChanged(AbstractSignalGroup * g, AbstractSignalGroup * newParent) const;
    void parentChanged(AbstractSignalGroup * g, AbstractSignalGroup * oldParent) const;
  };

} // namespace GeopsyCore

#endif // MASTERSIGNALGROUP_H
