/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-26
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "GuralpRecords.h"
#include "MetaDataFactory.h"

namespace GeopsyCore {

  /*!
    \class GuralpRecords GuralpRecords.h
    \brief Storage for Guralp block offsets inside one file

    Storage for Guralp blocks inside one file
  */

  REGISTER_METADATA(GuralpRecords)

  QString GuralpRecords::toString(const QString&) const
  {
    TRACE;
    QString str;
    int n=_records.count();
    for(int i=0; i<n; i++) {
      str+=QString::number(_records[i])+",";
    }
    return str;
  }

  bool GuralpRecords::fromString(const QString&, QString string)
  {
    TRACE;
    _records.clear();
    StringSection valSection(string);
    StringSection field;
    const QChar * ptr=0;
    while(true) {
      field=valSection.nextField(ptr, "," );
      if(!field.isValid()) return false;
      _records.append(field.toInt());
    }
    return true;
  }

} // namespace GeopsyCore
