/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-08-04
**  Copyright: 2010-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GEOPSYPLUGINS_H
#define GEOPSYPLUGINS_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GeopsyCoreInterface;

  class GEOPSYCORE_EXPORT GeopsyPlugins
  {
  public:
    GeopsyPlugins(bool debug=false);
    ~GeopsyPlugins();

    void polish();

    int count() const {return _list.count();}
    GeopsyCoreInterface * at(int index) const {return _list.at(index);}

    static QStringList getList(QStringList libs, bool& ok, bool debug=false);
    static GeopsyCoreInterface * load(QString pluginFile, bool debug=false);
  private:
    void init(bool debug);
    bool load();

    QList<GeopsyCoreInterface *> _list;
  };

} // namespace GeopsyCore

#endif // GEOPSYPLUGINS_H
