/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-05-03
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "FourierPlan.h"

namespace GeopsyCore {

  /*!
    \class FourierPlan FourierPlan.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing

    See details at https://en.wikipedia.org/wiki/Discrete-time_Fourier_transform
  */
  FourierPlan::FourierPlan(int n, double samplingPeriod, double frequency)
  {
    _n=n;
    _frequency=frequency; // Useless, for debug only
    double omega=-2.0*M_PI*frequency*samplingPeriod; // omega must be in rad/sample
    _base=new Complex[_n];
    double rn=::sqrt(2.0*samplingPeriod/static_cast<double>(n)); // Not the same factor as for FFT
                                                                 // Checked that it produces the same value as FFT
    for(int i=0; i<_n; i++) {
      _base[i].setExp(rn, static_cast<double>(i)*omega);
    }
  }

  /*!
    Description of destructor still missing
  */
  FourierPlan::~FourierPlan()
  {
    delete [] _base;
  }

} // namespace GeopsyCore

