/***************************************************************************
**
**  This file is part of DinverDCGui.
**
**  DinverDCGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-05-19
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef VIEWERPARAM_H
#define VIEWERPARAM_H

#include <QGpCoreWave.h>
#include <QGpGuiTools.h>

#include "ui_ViewerParam.h"
#include "DinverDCGuiDLLExport.h"

namespace DinverDCGui {

class DCModelViewer;

class DINVERDCGUI_EXPORT ViewerParam : public Dialog, protected Ui::ViewerParam
{
  Q_OBJECT
public:
  ViewerParam(QWidget * parent=nullptr);

  DCModelViewer * groundProfile(QStringList reportFileNames) {return setViewer(0, reportFileNames);}
  DCModelViewer * dispersion(QStringList reportFileNames) {return setViewer(1, reportFileNames);}
  DCModelViewer * autocorr(QStringList reportFileNames) {return setViewer(2, reportFileNames);}
  DCModelViewer * ellipticity(QStringList reportFileNames) {return setViewer(3, reportFileNames);}
  DCModelViewer * refractionVp(QStringList reportFileNames) {return setViewer(4, reportFileNames);}
  DCModelViewer * refractionVs(QStringList reportFileNames) {return setViewer(5, reportFileNames);}
  DCModelViewer * magnetoTelluric(QStringList reportFileNames) {return setViewer(6, reportFileNames);}
  void select(DCModelViewer * w, const QVector<int> * indexes);
  void reject(DCModelViewer * w, const QVector<int> * indexes);
private slots:
  void on_viewer_currentIndexChanged(int index);
private:
  DCModelViewer * setViewer(int index, QStringList reportFileNames);

  void setOptionsEnabled(bool e);
  void setValueEnabled(bool e);
  void setSlownessEnabled(bool e);
  void setModeIndexEnabled(bool e);
  void setAxisEnabled(bool e);

  void setPolarizationRL();
  void setPolarizationVRT();

  void removeMaxMisfit();
  void removeOptions();
  void removeValue();
  void removeSlowness();
  void removePolarization();
  void removeModeIndex();
  void removeAxis();

  int exec();
  Mode mode() const;
  DCModelViewer * createViewer(int index);
};

} // namespace DinverDCGui

#endif // VIEWERPARAM_H
