/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-05-19
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MODALSTORAGEREADER_H
#define MODALSTORAGEREADER_H

#include <QGpCoreMath.h>

#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

class DINVERDCCORE_EXPORT ModalStorageReader
{
public:
  ModalStorageReader(QDataStream& s);

  int nModes() {return _nModes;}
  bool seek(QDataStream& s, int iMode);
  void setBetaReleaseOffsets(QDataStream& s, bool rayleigh);

  static void toPlot(QDataStream& s, Point2D * points);
  static void toAbsolutePlot(QDataStream& s, Point2D * points);
  static void toStream(QDataStream& s, QTextStream& sOut);
  static void toAbsoluteStream(QDataStream& s, QTextStream& sOut);
  static void toStream(QDataStream& s, QDataStream& sOut);
  static void toAbsoluteStream(QDataStream& s, QDataStream& sOut);
protected:
  int _nModes;
  QList<qint64> _offsets;
};

} // namespace DinverDCCore

#endif // MODALSTORAGEREADER_H
