/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-21
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ParamCondition.h"
#include "Parameter.h"

namespace DinverCore {

/*!
  \class ParamCondition ParamCondition.h
  \brief Cache to access all conditions including one parameter

  
*/

/*!
  Default constructor
*/
ParamCondition::ParamCondition()
{
  TRACE;
  _condition=nullptr;
  _paramIndex=0;
}

/*!
  Main constructor
*/
ParamCondition::ParamCondition(AbstractCondition * c, int paramIndex)
{
  TRACE;
  _condition=c;
  _paramIndex=paramIndex;
}

/*!
  Copy constructor
*/
ParamCondition::ParamCondition(const ParamCondition& c)
{
  TRACE;
  _condition=c._condition;
  _paramIndex=c._paramIndex;
}

} // namespace DinverCore
