/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-03-20
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef WAVENUMBERCONVERTER_H
#define WAVENUMBERCONVERTER_H

#include <QGpCoreWave.h>

#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT WaveNumberConverter
  {
  public:
    WaveNumberConverter(double frequency);

    void setTime(const DateTime& t) {_time=t;}
    const DateTime& time() const {return _time;}

    double frequency() const {return _frequency;}
    double slowness(const Point2D &k) const {return k.length()*_waveNumberFactor;}
    double azimuth(const Point2D &k) const;
  private:
    DateTime _time;
    double _frequency;
    double _waveNumberFactor;
  };

} // namespace ArrayCore

#endif // WAVENUMBERCONVERTER_H

