/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-04-13
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "SPACTool.h"
#include "SPACRing.h"
#include "StationPairs.h"

namespace ArrayCore {

  /*!
    \class SPACTool SPACTool.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  SPACTool::SPACTool()
    : AbstractArrayTool()
  {
    TRACE;
    setResults(new SPACResults);
    // Construct a default parameter structure.
    AbstractArrayTool::setParameters(SPACParameters());
  }

  /*!
    Description of destructor still missing
  */
  SPACTool::~SPACTool()
  {
    TRACE;
  }

  bool SPACTool::setSubPool(SubSignalPool *subPool)
  {
    TRACE;
    if(AbstractArrayTool::setSubPool(subPool)) {
      switch (array()->components()) {
      case StationSignals::VerticalComponent:
      case StationSignals::AllComponent:
        break;
      default:
        Message::warning(MSG_ID, tr("Creating array"),
                              tr( "Error while checking components: only vertical or 3 components are allowed."),
                              Message::cancel());
        return false;
      }
      return true;
    } else {
      return false;
    }
  }

  bool SPACTool::setParameters(const AbstractParameters &param)
  {
    TRACE;
    const SPACParameters * spacParam=dynamic_cast<const SPACParameters *>(&param);
    if(!spacParam) {
      qDebug() << "Parameters are not SPACParameters in SPACTool::setParameters.";
      return false;
    }
    if(!AbstractArrayTool::setParameters(param)) {
      return false;
    }
    SPACParameters * myParam=parameters();
    if(myParam->ringCount()==0) {
      autoRings();
      if(myParam->ringCount()==0) {
        App::log(tr("Error computing automic rings\n"));
      }
    }
    // At this step parameters are fine and they will be no longer modified
    return setLoop();
  }

  void SPACTool::autoRings()
  {
    TRACE;
    ArraySelection arraySel(array());
    StationPairs pairs(&arraySel);
    QVector<SPACRing> rings=SPACRing::autoRings(pairs);
    SPACParameters * myParam=parameters();
    int n=rings.count();
    for(int i=0; i<n; i++) {
      const SPACRing& r=rings.at(i);
      App::log(tr("Automatic ring %1\n").arg(r.toUserString()));
      myParam->addRing(r.minRadius(), r.maxRadius());
    }
  }

} // namespace ArrayCore

