/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-01-29
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HRFKRAYLEIGHRADIAL_H
#define HRFKRAYLEIGHRADIAL_H

#include "HRFKRayleigh.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT HRFKRayleighRadial : public HRFKRayleigh
  {
  public:
    HRFKRayleighRadial(FKCache * gridCache)
      : HRFKRayleigh(gridCache) {}

    virtual double value(const Point& kell, int index) const;
    virtual double value(const Point& kell) const;

    virtual double ellipticity(const Point& kell, bool& ok);
    virtual double noise(const Point&) const {return 0.0;}
    virtual double power(double optimumPower) const {return optimumPower;}

    virtual bool refine(const Point2D & k, double ell0,
                        FKPeaks * results,
                        const WaveNumberConverter& conv);
  };

} // namespace ArrayCore

#endif // HRFKRAYLEIGHRADIAL_H

