/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-02-02
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CONVFKRAYLEIGH_H
#define CONVFKRAYLEIGH_H

#include "AbstractFKFunction.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ConvFKRayleigh : public AbstractFKFunction
  {
  public:
    ConvFKRayleigh(FKCache * gridCache);

    virtual void resetCrossSpectrum();
    virtual void addCrossSpectrum();
    virtual void meanCrossSpectrum(int nBlocks);

    virtual bool initGrid(int n);
    virtual void setGrid(FKGridSearch * g, double step, double size);
    virtual void initGrid(const Point& kell, int index);

    virtual double value(const Point& kell, int index) const;
    virtual double value(const Point& kell) const;

    virtual bool hasEllipticity() const {return true;}
    virtual double ellipticity(const Point& kell, bool& ok) {ok=true; return ::tan(kell.z());}
  };

} // namespace ArrayCore

#endif // CONVFKRAYLEIGH_H

