/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-03-23
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ARRAYSTATIONS_H
#define ARRAYSTATIONS_H

#include <GeopsyCore.h>

#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ArrayStations : public StationList
  {
    TRANSLATIONS("ArrayStations")
  public:
    ArrayStations();

    enum Mode {Vertical, Horizontal, ThreeComponents};

    Rect rectangle() const;

    void setReference();
    const Point2D& reference() const {return _reference;}

    void setRelativePos(double magneticDeclination=0.0);
    Point2D toRelative(Point2D p) const;
    const QVector<Point2D>& relativePos() const {return _relativePos;}
    const Point2D& relativePos(int station) const {return _relativePos.at(station);}

    UtmZone utmZone(bool& ok) const;
    double radius() const;
    QString toString(int precision, char format) const;
    Mode mode() const;
  private:
    Point2D _reference;
    UtmZone _utmZone;
    double _magneticDeclination;

    QVector<Point2D> _relativePos;
  };

} // namespace ArrayCore

#endif // ARRAYSTATIONS_H
