/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-12-09
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIVEFKTASKMANAGER_H
#define ACTIVEFKTASKMANAGER_H

#include "FKTaskManager.h"
#include "ArrayCoreDLLExport.h"
#include "ActiveFKParameters.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ActiveFKTaskManager : public FKTaskManager
  {
  public:
    ActiveFKTaskManager(const ArraySelection * array,
                        const SeismicEvent * src,
                        IrregularGrid2D * grid);
    ~ActiveFKTaskManager();

    virtual bool setParameters(const ArrayParameters * p);
    const ActiveFKParameters * parameters() const {return static_cast<const ActiveFKParameters *>(_parameters);}
  protected:
    LoopWorker * newWorker();
  private:
    const SeismicEvent * _source;
    IrregularGrid2D * _grid;
  };

} // namespace ArrayCore

#endif // ACTIVEFKTASKMANAGER_H

