/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-04-08
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "TapePoint.h"

/*!
  \class TapePoint TapePoint.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

void TapePoint::operator=(const Point2D& o)
{
  TRACE;
  Point::operator=(o);
}

QString TapePoint::typeString(Type t)
{
  TRACE;
  switch(t) {
  case Fixed:
    return tr("Fixed");
  case North:
    return tr("North");
  case Eastward:
    return tr("Eastward");
  case Prior:
    return tr("Prior");
  case Free:
    break;
  }
  return tr("Free");
}

TapePoint::Type TapePoint::type(const QString& t)
{
  TRACE;
  if(t.count()>3) {
    switch(t[2].unicode()) {
    case 'x':
      if(t==tr("Fixed")) {
        return Fixed;
      }
      break;
    case 'r':
      if(t==tr("North")) {
        return North;
      }
      break;
    case 's':
      if(t==tr("Eastward")) {
       return Eastward;
      }
      break;
    case 'i':
      if(t==tr("Prior")) {
        return Prior;
      }
      break;
    case 'e':
      if(t==tr("Free")) {
        return Free;
      }
      break;
    default:
      break;
    }
  }
  return Free;
}
