/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-02-08
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef DOWNLOADGPSRAW_H
#define DOWNLOADGPSRAW_H

#include <QGpGuiTools.h>

#include "ui_DownloadGpsRaw.h"

class Station;

class DownloadGpsRaw : public Dialog, private Ui::DownloadGpsRaw
{
  Q_OBJECT
public:
  DownloadGpsRaw(QWidget * parent=nullptr);
  ~DownloadGpsRaw();

  void addStation(Station * s);

  void terminate();
  void toRinex();
private slots:
  void rawFileSize(int size);
  void rawFileReady();
  void rawFileError();
private:
  QMap<Station *, int> _stations;
};

#endif // DOWNLOADGPSRAW_H
