/***************************************************************************
**
**  This file is part of matfiles.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-07-15
**  Authors:
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "Plugin.h"
#include "MatFormat.h"

#include "matfilesInstallPath.h"
#include "matfilesVersion.h"
#include "GeopsyCoreVersion.h"

/*!
  \class Plugin Plugin.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Creates MAT format if not already created
*/
Plugin::Plugin()
{
  TRACE;
  if(GeopsyCoreEngine::instance()) {
    CustomFileFormats * formats=GeopsyCoreEngine::instance()->customFileFormats();
    MatFormat * f=new MatFormat;
    if(!formats->contains(f->name())) {
      formats->add(f);
    } else {
      delete f;
    }
#ifndef GP_MATLAB_LIBS
    App::log(1, tr("Not linked to Matlab libraries.\n"
                         "Partial Mat-file support for level 5 and up.\n"
                         "Send your request to geopsy.org if there is a need for more supported features.\n"));
#endif
  }
}

const char * Plugin::interfaceVersion() const
{
  return GEOPSYCORE_VERSION;
}

PACKAGE_INFO("matfiles", MATFILES)
#if(QT_VERSION < QT_VERSION_CHECK(5, 0, 0))
Q_EXPORT_PLUGIN2(matfiles, Plugin)
#endif
