/***************************************************************************
**
**  This file is part of hvtfa.
**
**  hvtfa is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  hvtfa is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-05-31
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**    Miriam Kristekova (Geophysical Institute, Academy of Sciences, Bratislava, Slovak Republic)
**
***************************************************************************/

#ifndef HVTFAPLUGIN_H
#define HVTFAPLUGIN_H

#include <GeopsyGui.h>

class HVTFAPlugin : public GeopsyGuiInterface
{
  Q_OBJECT
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
  Q_PLUGIN_METADATA(IID "org.geopsy.geopsyInterface")
#endif
  Q_INTERFACES(GeopsyCore::GeopsyCoreInterface)
public:
  QString tag() const {return "hvtfa";}
  QString title() const {return tr("H/V Time Frequency Analysis");}

  void createToolActions(QObject * toolFactory);
  AbstractToolWidget * createTool(int id, QWidget * wsParent) const;

  const char * interfaceVersion() const;
};

#endif // HVTFAPLUGIN_H
