/***************************************************************************
**
**  This file is part of gptime.
**
**  gptime is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gptime is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-19
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "gptimeVersion.h"
#include "gptimeInstallPath.h"
#include "TimeReader.h"

PACKAGE_INFO("gptime", GPTIME)

ApplicationHelp * help();

int main(int argc, char ** argv)
{
  CoreApplication a(argc, argv, help);

  // Options
  TimeReader reader;
  if(reader.setOptions(argc, argv) && reader.read(argc, argv) ) {
    return 0;
  } else {
    return 2;
  }
}

ApplicationHelp * help()
{
  TRACE;
  ApplicationHelp * h=new ApplicationHelp;
  h->setOptionSummary( "[OPTIONS] [FILES]" );
  h->setComments( "Operations with time: add, subtract, converts times provided through stdin or FILES. "
                  "Operation other than convert are not yet supported." );
  h->addGroup("gptime", "gptime");
  h->addOption("-i, -in-format FORMAT","Defines input time format. Several '-i' options are accepted. "
                                       "See '-h format' for specification (default=\"yyyy-MM-dd hh:mm:ss.zzz\").");
  h->addOption("-o, -out-format FORMAT","Defines output time format. See '-h format' for specification (default=\"time_t\").");
  h->addOption("-p PREC","Output precision for floating point numbers");
  h->addOption("-c COLUMN","Time is in column COLUMN (default=0, means all line). First column starts at index 1.");
  h->addOption("-d DELIMITERS","Column delimiter characters used by option '-c' (default=\" \\t\").");
  h->addOption("-s BYTE","Time starts at BYTE bytes from the beginning the line (default=0)");
  h->addOption("-e BYTE","Time ends at BYTE bytes from the beginning the line (default=end of line)");
  h->addOption("-verbose","Prints string defined by options -c, -s or -e before convertion.");
  h->addOption("-convert","Ouput converted times (default mode)");
  h->addOption("-relative", "Restricts to relative mode (default=absolute). "
                            "Input format is recognized automatically and '-i' is not allowed. "
                            "The output format must be only one letter. "
                            "See '-h relformats' for a list of available output formats.");
  h->addGroup("Absolute formats", "absformats");
  h->addOption("time_t","Number of seconds since Jan 1 1970 (default input format)");
  h->addOption("seconds since yyyyMMdd","Number of seconds since yyyy-MM-dd");
  h->addOption("julian","Julian day");
  h->addOption("doy","Day of year (1 to 365 or 366 for leap years)");
  h->addOption("dow","Day of week (1 to 7 corresponding to Monday to Sunday)");
  h->addOption("gps-dow","Day of GPS week (0=Sunday, 6=Saturday)");
  h->addOption("gps-week","GPS week counted from Sunday 1980-01-06");
  h->addOption("C", "Use C locale instead of the current one: English day and month names, decimal point.");
  h->addOption("D", "Allow default values for missing fields in input format. No effect on ouput format.");
  h->addOption("d", "The day as number without a leading zero (1 to 31)");
  h->addOption("dd", "The day as number with a leading zero (01 to 31)");
  h->addOption("ddd", "The abbreviated localized day name (e.g. 'Mon' to 'Sun')");
  h->addOption("dddd", "The long localized day name (e.g. 'Monday' to 'Sunday')");
  h->addOption("M", "The month as number without a leading zero (1-12)");
  h->addOption("MM", "The month as number with a leading zero (01-12)");
  h->addOption("MMM", "The abbreviated localized month name (e.g. 'Jan' to 'Dec')");
  h->addOption("MMMM", "The long localized month name (e.g. 'January' to 'December')");
  h->addOption("yy","The year as two digit number (00-99)");
  h->addOption("yyyy","The year as four digit number");
  h->addOption("h", "The hour without a leading zero (0 to 23 or 1 to 12 if AM/PM display, AM/PM for input only)");
  h->addOption("hh", "The hour with a leading zero (00 to 23 or 01 to 12 if AM/PM display, AM/PM for input only)");
  h->addOption("H", "The hour without a leading zero (0 to 12)");
  h->addOption("HH", "The hour with a leading zero (00 to 12)");
  h->addOption("m", "The minute without a leading zero (0 to 59)");
  h->addOption("mm", "The minute with a leading zero (00 to 59)");
  h->addOption("s", "The second without a leading zero (0 to 59)");
  h->addOption("ss", "The second with a leading zero (00 to 59)");
  h->addOption("sz", "The second including fraction of seconds (0 to 60, excluding 60)");
  h->addOption("ssz", "The second including fraction of seconds (00 to 60, excluding 60)");
  h->addOption("z", "The milliseconds without leading zeroes (0 to 999)");
  h->addOption("zzz", "The milliseconds with leading zeroes (000 to 999)");
  h->addOption("AP", "Interpret as an AM/PM time. AP must be either \"AM\" or \"PM\".");
  h->addOption("ap", "Interpret as an AM/PM time. ap must be either \"am\" or \"pm\".");
  h->addOption("'", "Any text inside single quotes is considered verbatim.");
  h->addGroup("Relative formats", "relformats");
  h->addOption("w","Number of weeks, of days (if any), of hours (if any),... Ex: 2w3d4h59m47s.");
  h->addOption("d","Number of days, of hours (if any), of minutes (if any),... Ex: 17d4h59m47s.");
  h->addOption("h","Number of hours, of minutes (if any) and of seconds (if any). Ex.: 412h59m47s");
  h->addOption("m","Number of minutes and of seconds (if any). Ex: 24779m47s");
  h->addOption("s","Number of seconds. Ex: 1486787s.");
  h->addOption("g","Number of seconds with scientific/optimum notation.");
  h->addOption("f","Number of seconds with fixed decimals.");
  return h;
}
