/***************************************************************************
**
**  This file is part of gprefra.
**
**  gprefra is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gprefra is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-09-03
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>

#include "RefraReader.h"
#include "gprefraVersion.h"
#include "gprefraInstallPath.h"

PACKAGE_INFO("gprefra", GPREFRA)

ApplicationHelp * help();

int main(int argc, char ** argv)
{
  CoreApplication a(argc, argv, help);

  RefraReader reader;
  if(reader.setOptions(argc, argv) && reader.read(argc, argv) ) {
    return 0;
  } else {
    return 2;
  }
}

ApplicationHelp * help()
{
  ApplicationHelp * h=new ApplicationHelp;
  h->setOptionSummary( "[OPTIONS] [FILE1 [FILE2 ...]]" );
  h->setComments( "Compute traveltimes for a layered model with titled interfaces given through stdin or FILE.\n\n"
                  "Format for titled layered models:\n"
                 + RefractionDippingModel::formatHelp() +
                 "\n\n"
                  "Each model is defined by two depth profiles on the left and right. Any number of models "
                  "can be given as input.");
  h->addGroup("Gprefra","gprefra");
  h->addOption("-travel-times","Compute travel times (default mode).");
  h->addOption("-ray-paths","Compute ray paths.");
  h->addOption("-src <X1[,X2,..]>","Add a source point at X.");
  h->addOption("-rec <X1[,X2,..]>","Add a receiver point at X.");
  h->addExample("cat << END > test.model\n"
                "2\n"
                "0 60\n"
                "10 10 300\n"
                "0 0 1500\n"
                "END",
                "Create a two-layer model (300 and 1500 m/s).");
  h->addExample("gprefra -travel-times -src -5 -src 27.5,60 -rec 0,5,10,15,20,25,30,35,40,45,50,55 < test.model",
                "Arrival times on 12 receivers with a 5 m spacing.");
  h->addExample("gprefra -travel-times -src -5 -src 27.5,60 -rec 0,5,10,15,20,25,30,35,40,45,50,55 < test.model | "
                "figue -c -m tt.mkup -l tt3.legend",
                "Plot travel times. Options -m and -l are not mandatory (see figue -h).");
  return h;
}
