/***************************************************************************
**
**  This file is part of gpprofile.
**
**  gpprofile is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpprofile is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-02-21
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>

#include "ProfileReader.h"
#include "gpprofileVersion.h"
#include "gpprofileInstallPath.h"

PACKAGE_INFO("gpprofile", GPPROFILE)

ApplicationHelp * help();

int main(int argc, char * argv[])
{
  CoreApplication a(argc, argv, help);

  ProfileReader reader;
  if(reader.setOptions(argc, argv) && reader.read(argc, argv) && reader.terminate()) {
    return 0;
  } else {
    return 2;
  }
}

ApplicationHelp * help()
{
  ApplicationHelp * h=new ApplicationHelp;
  h->setOptionSummary( "[OPTIONS] [FILE1 [FILE2 ...]]" );
  h->setComments( "Print profile computed from various kinds of layered model given through stdin or FILE\n\n"
                  +GeophysicalModel::allFormatHelp()+
                 "Any number of models can be given as input.");
  h->addGroup("Model type","model");
  h->addOption("-surfacewave-models","Surface wave models are expected as input (default)");
  h->addOption("-refraction-models","Refraction models are expected as input");
  h->addOption("-resistivity-models","Resistivity models are expected as input");
  h->addGroup("Profile type","profile");
  h->addOption("-vp","Export Vp profiles");
  h->addOption("-vs","Export Vs profiles (default)");
  h->addOption("-rho","Export density profiles");
  h->addOption("-nu","Export Poisson's ratio profiles");
  h->addOption("-imp","Export impedance profiles");
  h->addOption("-res","Export resistivity profiles");
  h->addOption("-model","Export 1D model (only for pseudo 3D mode, see '-h output')");
  h->addGroup("Output type","output");
  h->addOption("-original","Export profiles with original sampling from input models (default)");
  h->addOption("-resample","Export profiles with a custom sampling (see -h sampling for details)");
  h->addOption("-at <DEPTH>","Returns the profile value at DEPTH meters.");
  h->addOption("-average-profiles","Export averaged profiles with a custom sampling (see '-h sampling' for details). "
                                   "Various profiles are averaged into one single output.");
  h->addOption("-average-depths","Export averaged profiles with a custom sampling (see '-h sampling' for details). "
                                 "Average is performed over the depth axis.");
  h->addOption("-average-at <DEPTH>","Returns the average profile over DEPTH meters.");
  h->addOption("-minmax","Export minimum and maximum profiles with a custom sampling (see '-h sampling' for details)");
  h->addOption("-pseudo3d <X Y>","Switches to pseudo 3D mode: only accepts 3 input models, with positions set as follow:\n\n"
               "  # position x1 y1 z1\n"
               "  model 1 (see above for format)\n"
               "  # position x2 y2 z2\n"
               "  model 2 (see above for format)\n"
               "  # position x3 y3 z3\n"
               "  model 3 (see above for format)\n\n"
               "All models must have the same number of layers. X Y is the requested position to interpolate. "
               "A 1D model is interpolated and profiles are returned at that position. The 1D models or the profiles "
               "are computed from the local surface altitude (in depth unit, no altitude).");
  h->addGroup("Depth sampling","sampling");
  h->addOption("-d, -max-depth <DEPTH>","Maximum depth for resampled output types (default=100m)");
  h->addOption("-n <N>","Number of samples for resampled output types (default=100)");
  return h;
}
