/***************************************************************************
**
**  This file is part of gplivemodel.
**
**  gplivemodel is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gplivemodel is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-10-16
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef RESULTSTHREAD_H
#define RESULTSTHREAD_H

#include <SciFigs.h>
#include <QGpCoreWave.h>

class ResultsThread : public Thread
{
  Q_OBJECT
public:
  ResultsThread(QObject * parent=nullptr);
  ~ResultsThread();

  virtual void start(QList<GeophysicalModel *> model);
  void terminate() {_terminated.fetchAndStoreOrdered(true);}
  bool terminated() {return _terminated.testAndSetOrdered(true,true);}
  void setAutomaticLimits(bool a);
  bool automaticLimits() const {return _automaticLimits;}

  virtual ResultsThread * clone() const=0;
  virtual bool setParameters(int& /*argc*/, char ** /*argv*/ ) {return true;}
  virtual GeophysicalModel * createModel() const=0;

  virtual void initModelGraphs(GraphicSheet * sheet)=0;
  virtual void initModelGraphs(const ResultsThread& o)=0;

  virtual void initResultsGraphs(GraphicSheet * sheet)=0;
  virtual void initResultsGraphs(const ResultsThread& o)=0;

  virtual void addModel(GeophysicalModel * m)=0;
  virtual void setModel(GeophysicalModel * m)=0;
  virtual void clear() {}

  virtual void setModelLimits()=0;
  virtual void setResultsLimits()=0;
  virtual void modelDeepUpdate()=0;
  virtual void resultsDeepUpdate()=0;
  virtual void run(GeophysicalModel * model)=0;
protected:
  LegendWidget * createLegend(GraphicSheet * sheet, double x, double y, const QString& t);
  virtual void run();

  QAtomicInt _terminated;
  QList<GeophysicalModel *> _models;
  bool _automaticLimits;
};

#endif // RESULTSTHREAD_H
