/***************************************************************************
**
**  This file is part of gplivemodel.
**
**  gplivemodel is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gplivemodel is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-10-04
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreWave.h>
#include <SciFigs.h>

#include "Results.h"
#include "DispersionThread.h"
#include "DispersionGridThread.h"
#include "EllipticityThread.h"
#include "ShAmplificationThread.h"
#include "MagnetoTelluricThread.h"

/*!
  \class Results Results.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
Results::Results(QWidget * parent)
    : GraphicSheet(parent)
{
  TRACE;

  _backgroundThread=0;
  _foregroundThread=0;
  _automaticLimits=true;

  setWindowTitle("Results");
}

/*!
  Description of destructor still missing
*/
Results::~Results()
{
  TRACE;
}

/*!
  Set curve type and fetch related arguments in \a argv
*/
bool Results::setCurveType(CurveType curveType, int& argc, char ** argv)
{
  TRACE;
  switch(curveType) {
  case Dispersion:
    _backgroundThread=new DispersionThread(this);
    break;
  case DispersionGrid:
    _backgroundThread=new DispersionGridThread(this);
    break;
  case Ellipticity:
    _backgroundThread=new EllipticityThread(this);
    break;
  case ShAmplification:
    _backgroundThread=new ShAmplificationThread(this);
    break;
  case MagnetoTelluric:
    _backgroundThread=new MagnetoTelluricThread(this);
    break;
  }

  if(!_backgroundThread->setParameters(argc, argv)) {
    return false;
  }
  _foregroundThread=_backgroundThread->clone();

  _backgroundThread->initModelGraphs(this);
  _backgroundThread->setObjectName("background");

  _foregroundThread->initModelGraphs(*_backgroundThread);
  _foregroundThread->setObjectName("foreground");

  _backgroundThread->initResultsGraphs(this);
  _foregroundThread->initResultsGraphs(*_backgroundThread);
  return true;
}

GeophysicalModel * Results::createModel() const
{
  TRACE;
  return _backgroundThread->createModel();
}

void Results::addBackground(GeophysicalModel * m)
{
  TRACE;
  _backgroundThread->addModel(m);
  _backgroundModels.append(m);
}

void Results::calculateBackground()
{
  calculate(_backgroundThread, _backgroundModels);
  if(_automaticLimits) {
    _backgroundThread->setModelLimits();
  }
  _backgroundThread->modelDeepUpdate();
}

void Results::clearBackground()
{
  TRACE;
  _backgroundThread->clear();
  _backgroundModels.clear();
  _backgroundThread->modelDeepUpdate();
}

void Results::setForeground(GeophysicalModel * m)
{
  TRACE;
  _foregroundThread->setModel(m);
  QList<GeophysicalModel *> mList;
  mList.append(m);
  calculate(_foregroundThread, mList);
  if(_automaticLimits) {
    _backgroundThread->setModelLimits();
  }
  _backgroundThread->modelDeepUpdate();
}

void Results::calculate(ResultsThread * t, QList<GeophysicalModel *> models)
{
  TRACE;
  if(t->isRunning()) {
    t->terminate();
    t->wait();
  }
  t->start(models);
}

void Results::setAutomaticLimits(bool a)
{
  TRACE;
  _automaticLimits=a;
  _backgroundThread->setAutomaticLimits(a);
  _foregroundThread->setAutomaticLimits(a);
}
