/***************************************************************************
**
**  This file is part of gpgridsearch.
**
**  gpgridsearch is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpgridsearch is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-04-25
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GRIDGENERATOR_H
#define GRIDGENERATOR_H

#include <DinverCore.h>

class GridGenerator
{
protected:
  GridGenerator(int variableCount, int subsetIndex, const Curve<Point1D> * values);
public:
  GridGenerator(int variableCount, const Curve<Point1D> * values);
  ~GridGenerator();

  bool next();
  void model(RealSpace& ps) const;
  qint64 count() const;
  qint64 currentIndex() const {return _modelCount;}

  GridGenerator * subset(int index) const;
  int subsetCount() const {return _subsetCount;}
  void setSubsetIndex(int minCount);
private:
  int _variableCount;
  Curve<Point1D> * _values;
  int * _currentIndex;
  double * _current;
  qint64 _modelCount;

  int _subsetIndex;
  int * _subsetIndexBase;
  int _subsetCount;
};

#endif // GRIDGENERATOR_H
