/***************************************************************************
**
**  This file is part of gpdc.
**
**  gpdc is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpdc is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-12-11
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DISPERSIONREADER_H
#define DISPERSIONREADER_H

#include <QGpCoreMath.h>

class DispersionReader : public ArgumentStdinReader
{
  TRANSLATIONS("DispersionReader")
public:
  DispersionReader();
  ~DispersionReader();

  bool setOptions(int& argc, char ** argv);
protected:
  virtual bool parse(QTextStream& s);
private:
  enum AppMode {CurveMode, GridMode, HalfSpace};

  AppMode _mode;

  int _nRayleigh, _nLove;
  bool _groupSlowness;

  SamplingParameters _sampling;

  int _vNSamples;
  double _vMinRange;
  double _vMaxRange;

  bool _force;
  bool _oneMode;
  bool _deltaK;

  int _halfSpaceIndex;

  QVector<double> _x;
};

#endif // DISPERSIONREADER_H
