/***************************************************************************
**
**  This file is part of geopsytfa.
**
**  geopsytfa is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsytfa is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-07-13
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <GeopsyGui.h>

#include "ToolTFA.h"
#include "ToolTFAd.h"
#include "TFAParameters.h"
#include "TFAResults.h"

/*!
  \class ToolTFA ToolTFA.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

#define _tfaRes static_cast<TFAResults*>(_childrenList[0])

/*!
  Description of constructor still missing
*/
ToolTFA::ToolTFA(QWidget * parent)
    : AbstractToolWidget(parent, 1)
{
  TRACE;
  QVBoxLayout * baseLayout=new QVBoxLayout(this);
  _d=new ToolTFAd(this);
  baseLayout->addWidget(_d);

  setWindowTitle("TFA toolbox");
  setWindowIcon(QIcon(":tfa-22x22.png"));
  setObjectName("ToolTFA");

  connect(_d->startBut,SIGNAL(clicked()),this,SLOT(start()));
  connect(_d->stopBut, SIGNAL(clicked()), this, SLOT(stop()) );
  connect(_d->reLoadParam,SIGNAL(clicked()),this,SLOT(loadLogParameters()));
  _d->stopBut->setEnabled(false);
  _childrenList[0]=0;
}

void ToolTFA::updateAllFields()
{
  TRACE;
  _d->timeLimits->updateAllFields();
  _d->freqSamp->updateAllFields();
  _d->wavelet->updateAllFields();
}

bool ToolTFA::initStations(SubSignalPool * subPool)
{
  TRACE;
  _d->timeLimits->setSubPool(subPool);
  return true;
}

void ToolTFA::start()
{
  TRACE;
  MessageContext mc;
  if(subPoolLocked()) return;
  lockSubPool();
  _d->stopBut->setEnabled(true);
  _d->startBut->setEnabled(false);
  if(!_tfaRes) {
    _childrenList[0]=new TFAResults;
    _tfaRes->setObjectName("TFAResults");
    _tfaRes->createObjects(subPool());
    QString str="TFA results - ";
    str+=subPool()->name();
    _tfaRes->setWindowTitle(str);
    GeopsyGuiEngine::instance()->addSubWindow(this, _tfaRes)->setUserClosable(false);
  }
  // Get parameters
  TFAParameters param;
  _d->getParameters(param);
  // Use index rather than _subPool, as signals may have been added to subpool
  // We are not processing them here.
  int nSig=subPool()->count();
  SignalDatabase * db=subPool()->database();
  GeopsyCoreEngine::instance()->setProgressMaximum(db, nSig);
  _terminated=false;
  for(int i=0;i<nSig;i++) {
    if(_terminated) break;
    GeopsyCoreEngine::instance()->setProgressValue(db, i);
    _tfaRes->compute(i, subPool()->at(i), param);
  }
  GeopsyCoreEngine::instance()->setProgressValue(db, nSig);

  unlockSubPool();
  _d->startBut->setEnabled(true);
}

void ToolTFA::stop()
{
  TRACE;
  _terminated=true;
  GeopsyCoreEngine::instance()->showMessage(subPool()->database(), tr("Computation stopped"));
  _d->stopBut->setEnabled(false);
}
