/***************************************************************************
**
**  This file is part of geopsytfa.
**
**  geopsytfa is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsytfa is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-07-13
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "TFAParameters.h"
#include "ToolTFAd.h"

/*!
  \class TFAParameters TFAParameters.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

TFAParameters::TFAParameters()
  : AbstractParameters()
{

}

TFAParameters::TFAParameters(const TFAParameters& o)
  : AbstractParameters(o)
{
  _range=o._range;
  _frequencySampling=o._frequencySampling;
  _wavelet=o._wavelet;
}

AbstractParameters * TFAParameters::clone() const
{
  TRACE;
  return new TFAParameters(*this);
}

void TFAParameters::setVersion(PARAMETERS_SETVERSION_ARGS)
{
  TRACE;
  _range.setVersion(version);
  _frequencySampling.setVersion(version);
  _wavelet.setVersion(version);
  AbstractParameters::setVersion(version);
}

void TFAParameters::collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS)
{
  TRACE;
  _range.collectKeywords(keywords, prefix, suffix);
  _frequencySampling.collectKeywords(keywords, prefix, " FREQUENCY"+suffix);
  _wavelet.collectKeywords(keywords, prefix, suffix);
}

QString TFAParameters::toString(PARAMETERS_TOSTRING_ARGS_IMPL) const
{
  TRACE;
  QString log;
  log+=_range.toString(prefix, suffix);
  log+=_frequencySampling.toString(prefix, " FREQUENCY"+suffix);
  log+=_wavelet.toString(prefix, suffix);
  return log;
}

