/***************************************************************************
**
**  This file is part of geopsyrefra.
**
**  geopsyrefra is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyrefra is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-14
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <GeopsyCore.h>
#include <QGpGuiTools.h>
#include "ToolRefrad.h"

/*
 *  Constructs a ToolRefrad as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 */
ToolRefrad::ToolRefrad(QWidget *parent, Qt::WindowFlags f)
    : QWidget(parent, f)
{
  TRACE;
    setupUi(this);
}

void ToolRefrad::setPickCount(int n)
{
  TRACE;
  QString str;
  for(int i=0; i<n; i++) {
    str=tr("pick %1").arg(i);
    averagePick->addItem(str);
    stddevPick->addItem(str);
  }
}

void ToolRefrad::on_outputFileBrowse_clicked()
{
  TRACE;
  QString str=Message::getSaveFileName(tr("Report file (*.report);;"
                                             "Target file (*.dvt)"), outputFile->text());
  if(str.length()>0) outputFile->setText(str);
}
