/***************************************************************************
**
**  This file is part of geopsyarray.
**
**  geopsyarray is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyarray is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-11-14
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ArrayPlugin.h"
#include "FKToolWidget.h"
#include "SPACToolWidget.h"
#include "ActiveFKToolWidget.h"

#include "geopsyarrayInstallPath.h"
#include "geopsyarrayVersion.h"
#include "GeopsyCoreVersion.h"

const char * ArrayPlugin::interfaceVersion() const
{
  return GEOPSYCORE_VERSION;
}

void ArrayPlugin::createToolActions(QObject * toolFactory)
{
  TRACE;
  QAction * a;

  a=new QAction(toolFactory);
  a->setText(tr("F-K"));
  a->setIcon(QIcon(":fk-22x22.png"));
  a->setStatusTip(tr("Frequency-wavenumber methods: conventional, high-resolution (Capon, 1969), RTBF (Wathelet et al. 2018), passive or active recordings."));
  connect(a, SIGNAL(triggered()), toolFactory, SLOT(showTool()));
  addAction(a);

  a=new QAction(toolFactory);
  a->setText(tr("SPAC"));
  a->setIcon(QIcon(":spac-22x22.png"));
  a->setStatusTip(tr("Spatial autocorrelation method for passive recordings (Bettig et al., 2001)."));
  connect(a, SIGNAL(triggered()), toolFactory, SLOT(showTool()));
  addAction(a);

  a=new QAction(toolFactory);
  a->setText(tr("Active FK"));
  a->setIcon(QIcon(":activefk-22x22.png"));
  a->setStatusTip(tr("Active frequency-wavenumber method (MASW)."));
  connect(a, SIGNAL(triggered()), toolFactory, SLOT(showTool()));
  addAction(a);
}

AbstractToolWidget * ArrayPlugin::createTool(int id, QWidget * wsParent) const
{
  TRACE;
  switch (id) {
  case 0:
    return new FKToolWidget(wsParent);
  case 1:
    return new SPACToolWidget(wsParent);
  case 2:
    return new ActiveFKToolWidget(wsParent);
  default:
    return nullptr;
  }
}

PACKAGE_INFO("geopsyarray", GEOPSYARRAY)
#if(QT_VERSION < QT_VERSION_CHECK(5, 0, 0))
Q_EXPORT_PLUGIN2(geopsyarray, ArrayPlugin)
#endif
