/***************************************************************************
**
**  This file is part of geopsyarray.
**
**  geopsyarray is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyarray is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-09-02
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIVEFKTOOLWIDGET_H
#define ACTIVEFKTOOLWIDGET_H

#include <ArrayCore.h>
#include <QGpGuiWave.h>
#include <GeopsyGui.h>

#include "ui_ActiveFKToolWidget.h"

class ActiveFKToolWidget : public AbstractToolWidget, protected Ui::ActiveFKToolWidget
{
  Q_OBJECT
public:
  ActiveFKToolWidget(QWidget * parent);
  ~ActiveFKToolWidget();

  virtual bool setSubPool(SubSignalPool * subPool);

  ActiveFKToolSet * tool() {return static_cast<ActiveFKToolSet *>(_tool);}
  const ActiveFKToolSet * tool() const {return static_cast<const ActiveFKToolSet *>(_tool);}
public slots:
  virtual void start();
private slots:
  void on_processTypeEdit_currentIndexChanged(int index);
  void on_currentSource_currentIndexChanged(int index);
  void setResultXAxis();
  void setResultYAxis();
  void timeWindowChanged();
  void addCurvePlot(LineLayer * w, QString caption);
  void newLine(int index, ModalLine * line);
  void adjustCurve();
  void graphSelected(GraphicObject * obj);
  void setWavelengthLimit(double waveLength);
  void setCurrentDisplaySource();
protected:
  FKParameters::ProcessType processType(int t) const;
  int processType(FKParameters::ProcessType t) const;

  void getParameters(ActiveFKParameters& param) const;
  void setParameters(const AbstractParameters * param);
  virtual AbstractParameters * parameters(AbstractParameters * param=nullptr) const;
  bool checkParameters(ActiveFKParameters * param) const;

  virtual void updateAllFields();
};

#endif
