/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef EXPORTFILETYPE_BASE_H
#define EXPORTFILETYPE_BASE_H

#include <GeopsyCore.h>
#include <QGpGuiTools.h>
#include "ui_ExportFileType.h"

class ExportFileType : public Dialog, private Ui::ExportFileType
{
  Q_OBJECT
public:
  ExportFileType(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);

  void setFormatList(bool addTableFormat);
  SignalFileFormat format() const;

  bool useOriginalBaseName() const;
  int maximumSignalsPerFile() const;

  void updateAllFields();
private slots:
  void on_maximumSignalsPerFileBut_toggled(bool c);
private:
  QList< QPair<QString, SignalFileFormat> > _formats;
};

#endif // QTBDIALOG_EXPORTFILETYPE_BASE_H
