/***************************************************************************
**
**  This file is part of figue.
**
**  figue is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  figue is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-07-27
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <SciFigs.h>

class MainWindow : public QMainWindow
{
  Q_OBJECT
public:
  MainWindow(QWidget* parent=0, Qt::WindowFlags f=Qt::Window);

  GraphicSheet * sheet() {return _sheet;}
public slots:
  void currentFileChanged(const QString& fileName);
  void fileExit();
  void helpDocumentation();
  void about();
protected:
  void closeEvent (QCloseEvent * e);
  void addActions();
  GraphicSheet * _sheet;
};

#endif // MAINWINDOW_H
