/***************************************************************************
**
**  This file is part of dinverdc.
**
**  dinverdc is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinverdc is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-31
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <DinverDCCore.h>
#include <QGpCoreTools.h>
#include <QGpGuiTools.h>
#include "TargetListFrameWidget.h"

#include <qvariant.h>
#include <QScrollArea>

#include "TargetListWidget.h"

/*
 *  Constructs a TargetListFrameWidget as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 */
TargetListFrameWidget::TargetListFrameWidget(QWidget *parent, Qt::WindowFlags f)
    : QWidget(parent, f)
{
  TRACE;
  setupUi(this);

  sheetFrameLayout=new QVBoxLayout(sheetFrame);
  sheetFrameLayout->setSpacing(6);
  sheetFrameLayout->setMargin(0);
  targetSheet=new QScrollArea(sheetFrame);
  sheetFrameLayout->addWidget(targetSheet);
  targetListWidget=new TargetListWidget();
  targetSheet->setWidget(targetListWidget);
}

/*
 *  Destroys the object and frees any allocated resources
 */
TargetListFrameWidget::~TargetListFrameWidget()
{
  TRACE;
  // no need to delete child widgets, Qt does it all for us
}
