/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-11-06
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <DinverCore.h>

#include "PluginPaths.h"
#include "dinverVersion.h"

PluginPaths::PluginPaths(QWidget * parent)
    : Dialog(parent)
{
  TRACE;
  setupUi(this);

  DinverPluginSettings reg;
  QStringList paths=reg.paths();
  pathList->addItems(paths);
}

PluginPaths::~PluginPaths()
{
  TRACE;}

void PluginPaths::on_addPath_clicked()
{
  TRACE;
#if defined (Q_OS_UNIX)
  QString path=Message::getExistingDirectory(tr("Add plugin search path"), tr("Dinver plugin (*.so)"));
#elif defined (Q_OS_WIN)
  QString path=Message::getExistingDirectory(tr("Add plugin search path"), tr("Dinver plugin (*.dll)"));
#elif defined (Q_OS_MAC)
  QString path=Message::getExistingDirectory(tr("Add plugin search path"), tr("Dinver plugin (*.dylib)"));
#endif
  if(!path.isEmpty()) pathList->addItem(path);
}

void PluginPaths::on_removePath_clicked()
{
  TRACE;
  delete pathList->takeItem(pathList->currentRow());
}

QStringList PluginPaths::getPaths()
{
  TRACE;
  QStringList paths;
  int n=pathList->count();
  for(int i=0; i<n; i++) {
    paths << pathList->item(i)->text();
  }
  DinverPluginSettings reg;
  reg.setPaths(paths);

  return paths;
}
