/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-26
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef NAModelsPlot_H
#define NAModelsPlot_H

#include <QGpCoreTools.h>
#include <SciFigs.h>
#include "PSViewer.h"

class PSViewer;
class TabNAModelsPlot;

class NAModelsPlot : public GraphContentLayer
{
  Q_OBJECT
  Q_PROPERTY(double dotDiameter READ dotDiameter WRITE setDotDiameter)
public:
  NAModelsPlot(AxisWindow * parent=nullptr);
  ~NAModelsPlot();

  virtual const QString& xml_tagName() const;
  static const QString xmlNAModelsPlotTag;

  virtual Rect boundingRect() const;
  virtual void setParent(GraphContent * parent);

  void setParamX(int px);
  void setParamY(int py);
  int paramX() const {return _paramX;}
  int paramY() const {return _paramY;}
  // Diameter of point on plot (in cm)
  double dotDiameter() const {return _size;}
  // Change diameter of point on plot (in cm)
  void setDotDiameter (double d) {_size=d;}
  // Diameter of point on plot (in cm)
  double dotDiameterMM() const {return _size*10.0;}
  // Change diameter of point on plot (in cm)
  void setDotDiameterMM (double d) {_size=d*0.1;}

  virtual bool hasProperties() {return true;}
  virtual void addProperties(PropertyProxy * pp);
  virtual void removeProperties(PropertyProxy * pp);
  virtual void properties(PropertyWidget * w) const;
  virtual void setProperty(uint wid, int pid, QVariant val);
protected:
  virtual void paintData(const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;
  void setAxisProperties(int paramIndex, Axis * axis);

  mutable PSViewer * _psViewer;
  int _paramX, _paramY;
  double _size;
  static uint _tab;

  bool saveParameters() const;
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual void xml_writeBinaryData(XML_WRITEBINARYDATA_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
private:
  void paramValue(double& x, double& y, double& misfit, ModelThreadList::const_iterator it) const;
};

#endif
