/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-11-22
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/
#if 0
#ifndef TICKS_H
#define TICKS_H

#include <QGpCoreTools.h>

#include "SciFigsDLLExport.h"

namespace SciFigs {

  class Axis;

  class SCIFIGS_EXPORT Ticks
  {
  public:
    Ticks();
    ~Ticks();

    int majorCount() const {return _majors.count();}
    int minorCount() const {return _minors.count();}

    double majorAt(int index) const {return _majors.at(index);}
    double minorAt(int index) const {return _minors.at(index);}

    void update(const Axis& axis);
  private:
    void updateDate(const Axis& axis);
    static QString timeFormat(double delta);

    QVector<double> _majors;
    QVector<double> _minors;
    QVector<QString> _labels;
  };

} // namespace SciFigs

#endif // TICKS_H

#endif
