/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-01-26
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpGuiTools.h>

#include "NameLineDelegate.h"

namespace SciFigs {

/*!
  \class NameLineDelegate NameLineDelegate.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

QWidget * NameLineDelegate::createEditor(QWidget * parent, const QStyleOptionViewItem &,
                                         const QModelIndex & index) const
{
  TRACE;
  DoubleSpinBox * w=new DoubleSpinBox(parent);
  connect(w, SIGNAL(valueChanged(double)), this, SLOT(commitWidgetData()));
  switch(index.column()) {
  case 0:
  case 1:
    w->setMinimum(-100);
    w->setMaximum(100);
    w->setSingleStep(0.05);
    break;
  default:
    w->setMinimum(-90);
    w->setMaximum(90);
    w->setSingleStep(10);
    break;
  }
  return w;
}

void NameLineDelegate::commitWidgetData()
{
  QWidget * w=qobject_cast<QWidget *>(sender());
  if(w) {
    emit commitData(w);
  }
}

void NameLineDelegate::setEditorData(QWidget *editor, const QModelIndex &index) const
{
  TRACE;
  DoubleSpinBox * w= qobject_cast<DoubleSpinBox *>(editor);
  if( !w) return;
  w->setValue(index.model()->data(index).toDouble());
}

void NameLineDelegate::setModelData(QWidget *editor, QAbstractItemModel *model,
                                    const QModelIndex &index) const
{
  TRACE;
  DoubleSpinBox * w= qobject_cast<DoubleSpinBox *>(editor);
  if( !w) return;
  if(model->data(index)!=w->value()) {
    model->setData(index, w->value());
    emit dataChanged();
  }
}

} // namespace SciFigs
