/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-11-25
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef XMLEDITOR_H
#define XMLEDITOR_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"
#include "XMLItem.h"

namespace QGpGuiTools {

  class XMLEditorDelegate : public QItemDelegate
  {
    Q_OBJECT
  public:
    XMLEditorDelegate(QObject *parent=0) : QItemDelegate(parent) {}

    QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option,
                          const QModelIndex &index) const;
    void setEditorData(QWidget *editor, const QModelIndex &index) const;
    void setModelData(QWidget *editor, QAbstractItemModel *model,
                      const QModelIndex &index) const;
  };

  class QGPGUITOOLS_EXPORT XMLEditor : public QTreeView
  {
    Q_OBJECT
  public:
    XMLEditor(QWidget * parent=nullptr);
    ~XMLEditor();

    XMLItem * model() const;
  private slots:
    virtual void contextMenuEvent(QContextMenuEvent * e);
    void excludeSelectedItems();
    void includeSelectedItems();
    void includeChanged(const QModelIndex& index);
  protected:
    void setEnabled(bool e, QList<XMLGenericItem *> itemList);
  private:
    QMenu * _menu;
  };

} // namespace QGpGuiTools

#endif // XMLEDITOR_H
