/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-28
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef EXPANDTABWIDGET_H
#define EXPANDTABWIDGET_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

  class TileWidget;
  class ExpandTabTitle;

  class QGPGUITOOLS_EXPORT ExpandTabWidget : public QWidget
  {
    Q_OBJECT
  public:
    ExpandTabWidget(QWidget * parent=nullptr);
    ~ExpandTabWidget();

    void addWidget(QString title, QWidget * w);
    void takeWidget(QWidget * w);
    QList<QWidget *> takeWidgets();
    bool isDocked(QWidget * w);

    void setTitlePrefix(QString p) {_titlePrefix=p;}

    uint key() const;
    void restoreState(const QByteArray& state);
    QByteArray saveState() const;
  signals:
    void sizeChanged();
  private slots:
    void moveWidgetUp();
    void moveWidgetDown();
    void dockWidget(ExpandTabTitle * t=0);
    void expandAll();
    void collapseAll();
    void addContextActions(QMenu * m);
    void resize(int);
  private:
    ExpandTabTitle * find(QWidget * w, int& index);

    QString _titlePrefix;
    QVBoxLayout * _vboxLayout;
  };

} // namespace QGpGuiTools

#endif // EXPANDTABWIDGET_H
