/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-02-23
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SMOOTHINGPARAMETERWIDGET_H
#define SMOOTHINGPARAMETERWIDGET_H

#include <QtGui>
#include <QGpCoreMath.h>

#include "ui_SmoothingParameterWidget.h"
#include "QGpGuiMathDLLExport.h"

namespace QGpGuiMath {

  class QGPGUIMATH_EXPORT SmoothingParameterWidget : public QWidget, private Ui::SmoothingParameterWidget
  {
    Q_OBJECT
  public:
    SmoothingParameterWidget(QWidget * parent=nullptr);
    ~SmoothingParameterWidget();

    void setUnit(const QString& u) {_unit=u;}

    void updateAllFields();

    void getParameters(SmoothingParameters& param) const;
    void setParameters(const SmoothingParameters& param);
  private slots:
    void on_methodEdit_activated(int);
    void on_widthTypeEdit_activated(int);
  signals:
    void parametersChanged();
  private:
    QString _unit;
  };

} // namespace QGpGuiMath

#endif // SMOOTHINGPARAMETERWIDGET_H
