/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-02-23
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "SmoothingParameterWidget.h"

namespace QGpGuiMath {

  /*!
    \class SmoothingParameterWidget SmoothingWidget.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  SmoothingParameterWidget::SmoothingParameterWidget(QWidget * parent)
      : QWidget(parent)
  {
    TRACE;
    setupUi(this);

#ifndef SAVITZKY_GOLAY
    delete methodEdit;
    methodEdit=nullptr;
    delete methodLabel;
    methodLabel=nullptr;
    delete orderLabel;
    orderLabel=nullptr;
    delete orderEdit;
    orderEdit=nullptr;
#else
    connect(orderEdit, SIGNAL(valueChanged(int)), this, SIGNAL(parametersChanged()));
#endif
    connect(windowFunctionEdit, SIGNAL(parametersChanged()), this, SIGNAL(parametersChanged()));
    connect(widthEdit, SIGNAL(valueChanged(const QString&)), this, SIGNAL(parametersChanged()));
  }

  /*!
    Description of destructor still missing
  */
  SmoothingParameterWidget::~SmoothingParameterWidget()
  {
    TRACE;
  }

  void SmoothingParameterWidget::updateAllFields()
  {
    TRACE;
    on_methodEdit_activated(0);
    windowFunctionEdit->updateAllFields();
    on_widthTypeEdit_activated(0);
  }

  void SmoothingParameterWidget::on_widthTypeEdit_activated(int)
  {
    TRACE;
    switch (widthTypeEdit->currentIndex()) {
    case 0:
      if(_unit.isEmpty()) {
        widthEdit->setSuffix(QString());
      } else {
        widthEdit->setSuffix(" "+_unit);
      }
      break;
    case 1:
    case 2:
      widthEdit->setSuffix(" %");
      break;
    }
    emit parametersChanged();
  }

  void SmoothingParameterWidget::on_methodEdit_activated(int)
  {
    TRACE;
#ifdef SAVITZKY_GOLAY
    switch (methodEdit->currentIndex()) {
    case 0:
      windowFunctionEdit->show();
      orderLabel->hide();
      orderEdit->hide();
      break;
    case 1:
      windowFunctionEdit->hide();
      orderLabel->show();
      orderEdit->show();
      break;
    }
    emit parametersChanged();
#endif
  }

  void SmoothingParameterWidget::getParameters(SmoothingParameters& param) const
  {
    TRACE;
#ifdef SAVITZKY_GOLAY
    switch(methodEdit->currentIndex()) {
    case 0:
      param.setMethod(SmoothingParameters::Function);
      break;
    case 1:
      param.setMethod(SmoothingParameters::SavitzkyGolay);
      break;
    }
    param.setOrder(orderEdit->value());
#endif
    windowFunctionEdit->getParameters(param.windowFunction());
    switch(widthTypeEdit->currentIndex()) {
    case 0:
      param.setWidthType(SmoothingParameters::Constant);
      param.setWidth(widthEdit->value());
      break;
    case 1:
      param.setWidthType(SmoothingParameters::Proportional);
      param.setWidth(widthEdit->value()*0.01);
      break;
    case 2:
      param.setWidthType(SmoothingParameters::Log);
      param.setWidth(widthEdit->value()*0.01);
      break;
    }
    switch(scaleTypeEdit->currentIndex()) {
    case 0:
      param.setScaleType(SamplingParameters::Linear);
      break;
    case 1:
      param.setScaleType(SamplingParameters::Log);
      break;
    case 2:
      param.setScaleType(SamplingParameters::Inversed);
      break;
    }
  }

  void SmoothingParameterWidget::setParameters(const SmoothingParameters& param)
  {
    TRACE;
#ifdef SAVITZKY_GOLAY
    switch(param.method()) {
    case SmoothingParameters::Function:
      methodEdit->setCurrentIndex(0);
      break;
    case SmoothingParameters::SavitzkyGolay:
      methodEdit->setCurrentIndex(0);
      break;
    }
    orderEdit->setValue(param.order());
#endif
    windowFunctionEdit->setParameters(param.windowFunction());
    switch(param.widthType()) {
    case SmoothingParameters::Constant:
      widthTypeEdit->setCurrentIndex(0);
      widthEdit->setValue(param.width());
      break;
    case SmoothingParameters::Proportional:
      widthTypeEdit->setCurrentIndex(1);
      widthEdit->setValue(param.width()*100.0);
      break;
    case SmoothingParameters::Log:
      widthTypeEdit->setCurrentIndex(2);
      widthEdit->setValue(param.width()*100.0);
      break;
    }
    switch(param.scaleType()) {
    case SamplingParameters::Linear:
      scaleTypeEdit->setCurrentIndex(0);
      break;
    case SamplingParameters::Log:
      scaleTypeEdit->setCurrentIndex(1);
      break;
    case SamplingParameters::Inversed:
      scaleTypeEdit->setCurrentIndex(2);
      break;
    }
  }

} // namespace QGpGuiMath
