/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-13
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SAMPLINGPARAMETERWIDGET_H
#define SAMPLINGPARAMETERWIDGET_H

#include <QGpCoreMath.h>

#include "ui_SamplingParameterWidget.h"
#include "QGpGuiMathDLLExport.h"

namespace QGpGuiMath {

class QGPGUIMATH_EXPORT SamplingParameterWidget : public QWidget, private Ui::SamplingParameterWidget
{
  Q_OBJECT
public:
  SamplingParameterWidget(QWidget* parent=nullptr);

  void setUnit(QString u) {fromValue->setSuffix(u); toValue->setSuffix(u);}
  void setRangeOnly();
  void setPrecision(int digit);
  void setSingleStep(double s);
  void setAdmissibleRange(double min, double max);
  void setFrequency();

  void getParameters(SamplingParameters & param) {param=_param;}
  void setParameters(const SamplingParameters & param);
public slots:
  void updateAllFields();
private slots:
  void on_scaleTypeEdit_currentIndexChanged(int index);
  void on_stepCountOption_currentIndexChanged(int index);
  void on_stepCountValue_valueChanged(double val);
  void on_fromValue_valueChanged(double val);
  void on_toValue_valueChanged(double val);
signals:
  void parametersChanged();
private:
  double _admissibleMin, _admissibleMax;
  SamplingParameters _param;
};

} // namespace QGpGuiMath

#endif // SAMPLINGPARAMETERWIDGET_H
